<?php

#
# Read SOAP message example for devices P85xx/P86xx
#
# Requirements: P85xx/P86xx device (P8510, P8541, P8610, P8641, etc.) with firmware version 4-5-8-1 or higher
#               Apache server (tested with version 2.4.23)
#               PHP (tested with version 5.6.25)
#               Enabled SOAP extension for PHP (uncomment ";extension=php_soap.dll" in your php.ini)
#               P8xxxBinIn.wsdl must be in the same folder as this file
#               Uncommented line always_populate_raw_post_data = -1 in php.ini file <-- overit
#               Edit $filename property to requested ouptut file location
#
#  Purpose of this example is demonstration of communication with P85xx/P86xx device.
#  It is not intended to be used in production environment without further changes.
#

function InsertP8xxxSample($data)
{
  $filename = "D:\\output.txt";

  $msg = "Device name = " . $data->name . "\r\n";//DeviceName
  $msg .= "Serial number = " . $data->sn . "\r\n";//SerialNumber
  $msg .= "Device code = " . $data->kind . "\r\n";//DeviceCode
  $msg .= "Sending interval = " . $data->tmr . "\r\n";//SendingInterval

  $msg .= "\r\n";
  $msg .= "channels:". "\r\n";

  $ch = null;
  for ($i = 1; $i <= 5; $i++)
  {
    $msg .= "\r\n";
    $msg .= "channel " . $i . "\r\n";
    switch ($i)
    {
      case 1: $ch = $data->c1; break;
      case 2: $ch = $data->c2; break;
      case 3: $ch = $data->c3; break;
      case 4: $ch = $data->c4; break;
      case 5: $ch = $data->c5; break;
    }
    $msg .= "  Value = " . $ch->v . "\r\n";
    $msg .= "  Unit = " . $ch->u . "\r\n";
    $msg .= "  Alarm = " . $ch->a . "\r\n";
    $msg .= "  Enabled = " . $ch->e . "\r\n";
  }

  $file = fopen($filename,"a");
  fwrite($file, $msg);
  fclose($file);
}

ini_set("soap.wsdl_cache_enabled", "0");
$server = new SoapServer("P8xxxTRh.wsdl", array('uri' => "http://test-uri/"));
$server->addFunction('InsertP8xxxSample');
$server->handle();

?>
