﻿#
# Read states of binary inputs example
#
# Requirements: Python 3.6.1 ( www.python.org )
#               P8552  or P8652 device with firmware version 4-5-8-1 or higher
#
#  Purpose of this example is demonstration of communication with P85xx/P86xx device.
#  It is not intended to be used in production environment without further changes.
#

#Connection parameters
TCP_IP = '192.168.1.213'
TCP_PORT = 502

import socket, struct

sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
sock.connect((TCP_IP, TCP_PORT))

try:
    req = struct.pack('12B', 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x01, 0x03, 0x9C, 0x36, 0x00, 0x03)
    #send ModbusTCP request
    sock.send(req)
    '''
    Modbus TCP request:
       0x00 0x00 0x00 0x00 - transaction ID + protocol ID
       0x00 0x06           - length of following bytes
       0x01                - unit ID
       0x03                - function code (read holding registers)
       0x9C 0x36           - register address (from manual - 0x9C36=BIN1 state)
       0x00 0x03           - number of registers for reading (three bin inputs)
    '''
    
    #read ModbusTCP response
    rcv = sock.recv(64)
    #decode response
    out = struct.unpack(">IHccchhh", rcv)
    print("BIN1:", out[5],
          "\nBIN2:", out[6],
          "\nBIN3:", out[7])
    '''
    Modbus TCP response:
       0x00 0x00 0x00 0x00 - transaction ID + protocol ID
       0x00 0x09           - length of following bytes
       0x01                - unit ID
       0x03                - function code (read holding registers)
       0x06                - bytes count (=3x2)
       0x00 0x01 0x00 0x00 0x00 0x01 - response data
           0x00 0x01 = BIN1 state "1"
           0x00 0x00 = BIN2 state "0"
           0x00 0x01 = BIN3 state "1"
    '''
    
finally:
    sock.close()
